<?php
require_once("../layouts/members/head.php");
if ($user_data['challan_Check_Service'] == "YES") {
if (in_array($user_data['usertype'], ['Master Distributor', 'Distributor', 'Retailer'])) {
?>
<div class="row">
    <div class="col-md-4 mb-2">
      <div class="card text-danger">
        <div class="card-header bg-primary text-white py-2">
          <div class="d-flex align-items-center">
            <span class="mr-auto"><?= file_name() ?></span>
            <button class="btn btn-dark btn-sm ml-auto" onclick="history.back()">
              <i class="fas fa-arrow-left"></i> Back
            </button>
          </div>
        </div>
        <div class="p-3 text-dark">
          <?php
          $challans = []; // Initialize
          $vehicalinfo = []; // Initialize

          if (isset($_POST['submit'])) {
              $vehicalNumber = strtoupper(trim($_POST['vehicalNumber']));

              if (!empty($vehicalNumber)) {
                  $amount = $user_data['vehical_rc_fee'];
                  $old_balance = $user_data['balance'];
                  $new_balance = $old_balance - $amount;

                  if ($old_balance >= $amount) {
                      $order_id = order_txn_id();
                      
                      // --- NEW API IMPLEMENTATION START ---
                      $apiKey = "APIKEYPASTEE"; // Buy APi From This Website https://apizone.co.in ( Design & Development By APIZONE )

                      $apiUrl = "https://kycapizone.in/api/v2/dl/chalancheck.php?api_key=" . $apiKey . "&rc_number=" . $vehicalNumber;

                      $curl = curl_init();
                      curl_setopt_array($curl, array(
                         CURLOPT_URL => $apiUrl,
                         CURLOPT_RETURNTRANSFER => true,
                         CURLOPT_ENCODING => '',
                         CURLOPT_MAXREDIRS => 10,
                         CURLOPT_TIMEOUT => 30,
                         CURLOPT_FOLLOWLOCATION => true,
                         CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
                         CURLOPT_CUSTOMREQUEST => 'GET',
                         CURLOPT_SSL_VERIFYPEER => false,
                      ));

                      $responseApi = curl_exec($curl);
                      curl_close($curl);
                      
                      $json_data = json_decode($responseApi, true) ?? [];

                      // Check if API success (Status 200 based on your provided JSON)
                      if (isset($json_data['status']) && $json_data['status'] == '200') {
                          
                          $apiResult = $json_data['result'] ?? [];
                          $challans = $apiResult['challans'] ?? [];
                          
                          // Determine name for report (New API puts name inside challan list)
                          $name = 'NA';
                          if(!empty($challans) && isset($challans[0]['accusedName'])){
                              $name = $challans[0]['accusedName'];
                          }

                          $updateSuccess = db_update("members", ["balance" => $new_balance], "user_id='{$user_data['user_id']}'");

                          if ($updateSuccess) {
                              $insData = [
                                  'site_id'       => $site_data['site_id'],
                                  'user_id'       => $user_data['user_id'],
                                  'username'      => $user_data['username'],
                                  'name'          => $user_data['name'],
                                  'operator'      => $user_data['usertype'],
                                  'parent_id'     => $user_data['parent_id'],
                                  'order_id'      => $order_id,
                                  'service'       => "CHALLAN",
                                  'type'          => "Debit",
                                  'account_number'=> $vehicalNumber,
                                  'app_type'      => "CHALLAN",
                                  'amount'        => $amount,
                                  'main_amount'   => $amount,
                                  'old_balance'   => $old_balance,
                                  'new_balance'   => $new_balance,
                                  'txn_id'        => $order_id,
                                  'ref_id'        => $vehicalNumber,
                                  'description'   => "Rs.{$amount} Has Been Debit From Wallet for Name {$name} Vehical Number",
                                  'date_time'     => current_timestamp(),
                                  'status'        => "Success"
                              ];

                              $insertId = db_insert("reports", $insData);
                              if ($insertId) {
                                  // Prepare SMS Message
                                  $whamessage = "Dear {$user_data['name']},\nYour Request for Vehical Number *{$vehicalNumber}* TO Challan Find has been Complete.\n\n";
                                  
                                  if (!empty($challans)) {
                                      $whamessage .= "Total Challans Found: " . count($challans) . "\n";
                                      $whamessage .= "Latest Challan Date: " . ($challans[0]['challanDate'] ?? 'NA') . "\n";
                                      $whamessage .= "Amount: " . ($challans[0]['amount'] ?? '0') . "\n";
                                  } else {
                                      $whamessage .= "No Challans Found.\n";
                                  }
                                  
                                  $whamessage .= "\nBest Regards,\n_*{$site_data['brand']}.*_";
                                  send_sms($user_data['mobile'], $whamessage);
                              } else {
                                  awal_alert_msg("Insert Server Error!", 'error');
                              }
                          } else {
                              awal_alert_msg("Balance debited from wallet but not updated in the database. Please contact support!", 'error');
                          }
                      } else {
                          // Handle API Failure
                          $msg = $json_data['message'] ?? 'Server Down or Data Not Found';
                          awal_alert_msg($msg, 'error');
                      }
                      // --- NEW API IMPLEMENTATION END ---
                      
                  } else {
                      awal_alert_msg("Insufficient Wallet Balance!", 'error');
                  }
              } else {
                  awal_alert_msg("Please Fill All Valid Details!", 'error');
              }
          }
          ?>
          <form action="" method="POST" class="row">
            <div class="col-md-12 mb-3">
              <label>Vehical Number</label>
              <input type="text" name="vehicalNumber" placeholder="Enter Vehical Number" maxlength="15" oninput="this.value = this.value.toUpperCase().replace(/\s+/g, '');" class="form-control" required>
            </div>
            <div class="col-md-12 mb-3 d-flex justify-content-between">
              <button type="button" class="btn btn-secondary">
                <i class="fas fa-inr"></i> <?= $user_data['vehical_rc_fee']; ?>
              </button>
              <button type="submit" name="submit" class="btn btn-primary" onclick="return confirm('Are you sure?');">Submit</button>
            </div>
          </form>
        </div>
      </div>
    </div>
    <?php if (!empty($challans)) { ?>
      <div class="col-md-12 mt-4">
        <div class="card text-danger">
          <div class="card-header bg-primary text-white py-2">
            <span class="mr-auto">Challan Details</span>
          </div>
          <div class="table-responsive">
            <table class="table table-bordered table-striped">
              <thead>
                <tr style="text-align: center;">
                  <th>Challan Number</th>
                  <th>Name</th>
                  <th>Location</th>
                  <th>Source</th>
                  <th>Date</th>
                  <th>Penalty</th>
                  <th>Amount</th>
                  <th>Status</th>
                </tr>
              </thead>
              <tbody>
                <?php foreach ($challans as $challan) { ?>
                  <tr>
                    <td><?= $challan['challanNo'] ?? ''; ?></td>
                    <td><?= $challan['accusedName'] ?? ''; ?></td>
                    <td><?= $challan['challanPlace'] ?? ''; ?></td>
                    <td><?= $challan['stateCode'] ?? 'RTO'; ?></td>
                    <td><?= $challan['challanDate'] ?? ''; ?></td>
                    <td><?= $challan['offenseName'] ?? ''; ?></td>
                    <td><button class="btn btn-primary"><b><?= $challan['amount'] ?? '0'; ?></b></button></td>
                    <td>
                      <?php 
                        $status = strtolower($challan['challanStatus'] ?? '');
                        if ($status == 'paid' || $status == 'disposed') { 
                      ?>
                        <button class="btn btn-success"><b><?= strtoupper($status); ?></b></button>
                      <?php } else { ?>
                        <button class="btn btn-danger"><b><?= strtoupper($status); ?></b></button>
                      <?php } ?>
                    </td>
                  </tr>
                <?php } ?>
              </tbody>
            </table>
          </div>
        </div>
      </div>
    <?php } elseif (isset($_POST['submit']) && empty($challans) && isset($json_data['status']) && $json_data['status'] == '200') { ?>
      <div class="col-md-4 mb-2">
        <div class="card text-danger">
          <div class="card-header bg-success text-white py-2">
            <span class="mr-auto">No challans found for Vehicle Number: <strong><?= htmlspecialchars($vehicalNumber); ?></strong></span>
          </div>
          <div class="card-body">
             <p class="text-center text-dark">Great! This vehicle has no pending challans found in the database.</p>
          </div>
        </div>
      </div>
    <?php } ?>
</div>
<?php
} else {
    require_once("404.php");
}
} else {
      awal_alert_msg('You Do Not Have Any Challan Service Active!', 'info', 'dashboard');
}
require_once("../layouts/members/foot.php");
?>